
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*              Oktober 2018                         *
*****************************************************

*****************************************************
*     Vergleich von parametrischer und 
*     nicht-parametrischer Regression
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd   "C:\Users\Brüderl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files"        //Arbeitsverzeichnis
use  AllbReg, clear



*******************************************************************************
* Beispiel Scattergramm: Einkommen nach Bildung
twoway (scatter eink bild,           msymbol(o) mcolor(red))                ///
       (lowess  eink bild, bwidth(0.8) lwidth(thick) lcolor(blue)) if ost==0 & eink<8000,  ///
       xlabel(8(2)24, labsize(medium))                                      ///
       ylabel(0(1000)8000, angle(0) labsize(medium))                        ///
       xtitle("Bildung in Jahren", size(large) margin(0 0 0 2))             ///
       ytitle("Monatsnettoeinkommen", size(large)) legend(off) aspectratio(0.75)
twoway (scatter eink bild, jitter(2) msymbol(o) mcolor(red))                ///
       (lowess  eink bild, bwidth(0.3) lwidth(thick) lcolor(blue)) if ost==0 & eink<8000,  ///
       xlabel(8(2)24, labsize(medium))                                      ///
       ylabel(0(1000)8000, angle(0) labsize(medium))                        ///
       xtitle("Bildung in Jahren", size(large) margin(0 0 0 2))             ///
       ytitle("Monatsnettoeinkommen", size(large)) legend(off) aspectratio(0.75)

	   

*******************************************************************************	   
* Regression: Links-Rechts auf Alter
* Links-Rechts Selbsteinstufung (Skala von 1-10)
* Alter des Befragten in Jahren
regress rechts alter if ost==0

* Scattergram mit eingezeichneter Regressionsgerade
twoway (scatter rechts alter, jitter(10) msymbol(o) mcolor(blue))    ///
       (lfit    rechts alter, lwidth(thick) lcolor(red))  if ost==0, ///
       xlabel(10(10)100, labsize(medium))                            ///
       ylabel(1(1)10, angle(0) labsize(medium))                      ///
       xtitle("Alter", size(large) margin(0 0 0 2))                  ///
       ytitle("rechte politische Einstellung", size(large))          ///
       legend(lab(1 "beobachtete Werte") lab(2 "Regressionsgerade")  ///
	          size(medlarge))

* Scattergram mit eingezeichneter Regressionsgerade und Lowess
twoway (scatter rechts alter, jitter(10) msymbol(o) mcolor(blue))      ///
       (lfit    rechts alter, lwidth(thick) lcolor(red))               ///
       (lowess  rechts alter, lwidth(thick) lcolor(orange)) if ost==0,  ///
       xlabel(10(10)100, labsize(medium))                           ///
       ylabel(1(1)10, angle(0) labsize(medium))                     ///
       xtitle("Alter", size(large) margin(0 0 0 2))                 ///
       ytitle("rechte politische Einstellung", size(large))         ///
       legend(order (2 3) lab(2 "Regressionsgerade")                ///
	          lab(3 "Lowess") size(medlarge)) 

